#include "setup_parser.h"

#include "credentials.h"
#include "wifi_type.h"

#include <yandex_io/libs/base/utils.h>

using namespace quasar;
using namespace quasar::SetupParser;

Credentials SetupParser::parseInitData(const std::vector<byte>& bytes) {
    int wifiType = bytes[0];

    std::string SSID;
    int offset;
    short hashCode = 0;

    if (wifiType == WifiType::WIFI_TYPE_UNKNOWN) {
        hashCode = (short)(bytes[1] + (bytes[2] << 8));
        offset = 3;
    } else if (wifiType == WifiType::WIFI_TYPE_NONE) {
        offset = 1;
    } else {
        const int ssidLength = bytes[1];
        SSID = bytesToString(bytes, 2, ssidLength);
        offset = 2 + ssidLength;
    }

    std::string password;

    if (wifiType != WifiType::WIFI_TYPE_NONE) {
        const int passwordLength = bytes[offset++];
        password = bytesToString(bytes, offset, passwordLength);
        offset += passwordLength;
    }

    const int codeLength = bytes[offset++];
    const std::string tokenCode = bytesToString(bytes, offset, codeLength);
    offset += codeLength;

    auto credentials = Credentials(wifiType, std::vector<std::string>{SSID}, hashCode, password, tokenCode);
    return credentials;
}
