#pragma once
#include "i_signal.h"

namespace quasar {

    struct ILiveDataTag {};

    template <class Value>
    class ILiveData: public ISignal<Value>, public ILiveDataTag {
    public:
        using ValueType = Value;

        virtual ~ILiveData() = default;

        virtual Value value() const noexcept = 0;

        operator Value() const noexcept {
            return value();
        }
    };

} // namespace quasar
