#pragma once

#include <yandex_io/libs/threading/lifetime.h>

#include <chrono>
#include <functional>
#include <stdexcept>

namespace quasar {

    class ICallbackQueue;
    namespace helpers {
        template <typename... Args>
        struct Types {
            using Slot = std::function<void(Args...)>;
            using Tuple = std::tuple<typename std::remove_reference<Args>::type...>;
        };

        template <>
        struct Types<void> {
            using Slot = std::function<void()>;
            using Tuple = std::tuple<>;
        };

    } // namespace helpers

    struct SignalConnectionId {
        uint32_t value{0};
    };

    template <typename... Args>
    class ISignal {
    public:
        using Slot = typename helpers::Types<Args...>::Slot;
        using Tuple = typename helpers::Types<Args...>::Tuple;

        virtual ~ISignal() = default;

        virtual SignalConnectionId connect(Slot slot, const Lifetime::Tracker& tracker) noexcept = 0;
        virtual SignalConnectionId connect(Slot slot, const Lifetime::Tracker& tracker, std::shared_ptr<ICallbackQueue> callbackQueue) noexcept = 0;
        virtual bool disconnect(SignalConnectionId) noexcept = 0;
    };

    template <class Signal>
    bool waitSignal(Signal& signal, std::chrono::milliseconds timeout);

    template <class Signal>
    bool waitSignal(Signal& signal, std::chrono::milliseconds timeout, typename Signal::Slot slot);

} // namespace quasar

#include "i_signal.inl"
