#include "i_signal.h"
#include <yandex_io/libs/threading/steady_condition_variable.h>
#include <atomic>
#include <mutex>

namespace quasar
{

template<class Signal>
bool waitSignal(Signal& signal, std::chrono::milliseconds timeout)
{
    return waitSignal(signal, timeout, typename Signal::Slot());
}

template<class Signal>
bool waitSignal(Signal& signal, std::chrono::milliseconds timeout, typename Signal::Slot slot)
{
    SteadyConditionVariable cv;
    std::mutex mutex;
    std::atomic<bool> signaled{ false };
    std::atomic<bool> ready{ false };
    typename Signal::Slot waiter = 
        [&](auto&&...args) {
            bool expected = false;
            if (signaled.compare_exchange_strong(expected, true)) {
                if (slot) {
                    slot(std::forward<decltype(args)>(args)...);
                }
                ready = true;
                cv.notify_all();
            }
        };

    Lifetime lifetime;
    std::unique_lock lock(mutex);
    auto scid = signal.connect(waiter, lifetime);
    cv.wait_for(lock, timeout, [&] { return ready.load(); });
    lifetime.die();
    signal.disconnect(scid);
    return ready;
}

} // namespace quasar
