#pragma once

#include "signal_base.h"

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <mutex>
#include <type_traits>
#include <utility>
#include <vector>

namespace quasar {

    template <class S>
    class Signal: public SignalBase<S> {
    public:
        Signal() = default;
        Signal(const Signal&) = delete;
        Signal& operator=(const Signal&) = delete;

        template <typename... Args>
        void operator()(Args... args) noexcept {
            SignalBase<S>::forEachSlot(
                [&](const typename S::Slot& slot)
                {
                    slot(std::forward<Args>(args)...);
                });
        }
    };

} // namespace quasar
