#include "signal_base.h"

#include <yandex_io/libs/logging/logging.h>

using namespace quasar;

YIO_DEFINE_LOG_MODULE("signal");

uint32_t SignalPrivate::allocateConnectionId()
{
    static std::atomic<uint32_t> id{0};
    return ++id;
}

void SignalPrivate::logException()
{
    try {
        throw;
    } catch (const std::exception& ex) {
        YIO_LOG_ERROR_EVENT("Signal.SlotException.LogException", "Unexpected exception in signal slot: " << ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("Signal.SlotException.LogUnknownError", "Unexpected exception in signal slot: ...");
    }
}
