#pragma once
#include "signal_base.h"

namespace quasar {

    class NoDataForSignal: public std::exception {
    public:
        const char* what() const noexcept override {
            return "no data for signal";
        }
    };

    template <class S>
    class SignalExternal: public SignalBase<S> {
    public:
        SignalExternal(std::function<typename S::Tuple(bool onConnect)> externalState, const Lifetime& stateLifetime)
            : stateTracker_(stateLifetime.tracker())
            , externalState_(std::move(externalState))
        {
        }
        SignalExternal(const SignalExternal&) = delete;
        SignalExternal& operator=(const SignalExternal&) = delete;

        void emit() noexcept {
            if (auto lock = stateTracker_.lock()) {
                try {
                    auto tuple = externalState_(false);
                    SignalBase<S>::forEachSlot(
                        [&](const typename S::Slot& slot)
                        {
                            std::apply(slot, tuple);
                        });
                } catch (const NoDataForSignal&) {
                }
            }
        }

    private:
        void beforeConnect(const typename S::Slot& slot, const Lifetime::Tracker& tracker, const std::shared_ptr<ICallbackQueue>& callbackQueue) noexcept override {
            if (!callbackQueue) {
                if (auto lock1 = stateTracker_.lock()) {
                    if (auto lock2 = tracker.lock()) {
                        try {
                            std::apply(slot, externalState_(true));
                        } catch (const NoDataForSignal&) {
                        }
                    }
                }
            } else {
                callbackQueue->add(
                    [this, slot, slotTracker = tracker, stateTracker = stateTracker_] {
                        if (auto lock1 = stateTracker.lock()) {
                            if (auto lock2 = slotTracker.lock()) {
                                try {
                                    std::apply(slot, externalState_(true));
                                } catch (const NoDataForSignal&) {
                                }
                            }
                        }
                    });
            }
        }

    private:
        Lifetime::Tracker stateTracker_;
        std::function<typename S::Tuple(bool onConnect)> externalState_;
    };

} // namespace quasar
