#pragma once

#include "signal_base.h"

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <map>
#include <mutex>

namespace quasar {

    class ISignalReady: public ISignal<void> {
    public:
        virtual bool isReady() const noexcept = 0;
    };

    class SignalReady: public ISignalReady {
    public:
        SignalReady() = default;
        SignalReady(const SignalReady&) = delete;
        SignalReady& operator=(const SignalReady&) = delete;

        bool isReady() const noexcept override;
        void operator()() noexcept;

    public: // ISignal
        SignalConnectionId connect(Slot slot, const Lifetime::Tracker& tracker) noexcept override;
        SignalConnectionId connect(Slot slot, const Lifetime::Tracker& tracker, std::shared_ptr<ICallbackQueue> callbackQueue) noexcept override;
        bool disconnect(SignalConnectionId /*signalConnectionId*/) noexcept override;

    private:
        mutable std::mutex mutex_;
        bool fReady_{false};
        std::map<uint32_t, Slot> slots_;
    };

} // namespace quasar
