#pragma once

#include <contrib/libs/sqlite3/sqlite3.h>

#include <memory>
#include <mutex>
#include <string>
#include <vector>

namespace quasar {

    class SqliteDatabase {
    public:
        SqliteDatabase(std::string databasePath, uint64_t maxSizeKB = -1);
        virtual ~SqliteDatabase();

        int getDatabaseSizeInBytes();
        const std::string& getDbFilename() const;

        void backupToFile(const std::string& backupFilename);
        void checkIntegrity();

    protected:
        void cleanup();
        void initDatabase();
        int getDbSizeUnlocked();
        void runQueryWithoutCallback(const std::string& query);
        void vacuum();
        bool isEnoughMemoryForInsert(const std::string& newItem);
        void logQueryError(std::string_view sql, std::string_view message);

        sqlite3* db_{nullptr};
        std::string dbFilename_;
        int maxDbSizeKb_{};
        std::mutex mutex_;
    };

} // namespace quasar
