#include "subprocess.h"

#include <util/system/shellcommand.h>

using namespace quasar;

namespace {

    class IOutputStreamTail: public IOutputStream {
    public:
        explicit IOutputStreamTail(size_t tailSizeInBytes)
            : data_(tailSizeInBytes)
        {
            Y_VERIFY(tailSizeInBytes > 0);
        }

        std::string data() const {
            std::string result;
            result.reserve(data_.AvailSize());
            for (size_t i = 0; i < data_.AvailSize(); ++i) {
                result.push_back(data_[data_.FirstIndex() + i]);
            }
            return result;
        }

        size_t size() const noexcept {
            return data_.AvailSize();
        }

    private:
        void DoWrite(const void* buf, size_t len) override {
            const char* cbuf = static_cast<const char*>(buf);
            for (size_t i = 0; i < len; ++i) {
                data_.PushBack(cbuf[i]);
            }
        }

    private:
        TSimpleRingBuffer<char> data_;
    };

} // anonymous namespace

SystemOutput quasar::getSystemCommandOutputTail(const std::string& command, const std::vector<std::string>& args, uint64_t tailSizeInBytes) {
    TShellCommandOptions options;
    IOutputStreamTail outputStream(tailSizeInBytes);
    IOutputStreamTail errorStream(tailSizeInBytes);

    options.SetOutputStream(&outputStream).SetErrorStream(&errorStream);
    options.SetCloseAllFdsOnExec(true);
    options.SetUseShell(false);

    TShellCommand cmd(command, TList<TString>{args.begin(), args.end()}, options);
    cmd.Run();

    if (cmd.GetStatus() == TShellCommand::SHELL_INTERNAL_ERROR) {
        throw std::runtime_error(cmd.GetInternalError());
    }

    return {outputStream.data(), errorStream.data()};
}

int quasar::runSystemCommand(const std::string& command, const std::vector<std::string>& args) {
    TShellCommandOptions options;
    options.SetCloseAllFdsOnExec(true);
    options.SetUseShell(false);

    TShellCommand cmd(command, TList<TString>{args.begin(), args.end()}, options);
    cmd.Run();

    if (cmd.GetStatus() == TShellCommand::SHELL_INTERNAL_ERROR) {
        throw std::runtime_error(cmd.GetInternalError());
    }

    return *cmd.GetExitCode();
}
