#include "file.h"

#include <cstring>
#include <errno.h>

namespace SweepToneGen {

    File::File() {
    }

    File::~File() {
        // specify member owner to disable virtual dispatching
        File::close();
    }

    bool File::init(const std::string& filename) {
        file.open(filename.c_str(), std::ios::out | std::ios::binary);
        if (file.fail()) {
            return false;
        }

        isOpened = true;
        return true;
    }

    bool File::write(const void* buf, size_t len) {
        if (!file.good()) {
            return false;
        }

        file.write(reinterpret_cast<char*>(const_cast<void*>(buf)), len);
        if (file.bad() || file.fail()) {
            return false;
        }

        return true;
    }

    void File::close() {
        if (!isOpened) {
            return;
        }

        if (!file.good()) {
            return;
        }

        file.close();
        isOpened = false;
    }

    bool File::write(size_t pos, const void* buf, size_t len) {
        file.seekp(pos, std::ios::beg);
        if (file.bad() || file.fail()) {
            return false;
        }

        return write(buf, len);
    }

    bool File::read(const std::string& fileName, std::vector<uint8_t>& data) {
        FILE* fs = fopen(fileName.c_str(), "rb");

        if (fs == nullptr) {
            return false;
        }

        fseek(fs, 0, SEEK_END);
        const auto size = ftell(fs);
        rewind(fs);

        data.resize(size);
        const auto bytesRead = fread(&data[0], 1, size, fs);
        if (bytesRead != (size_t)size) {
            fclose(fs);
            return false;
        }

        fclose(fs);
        return true;
    }

} // namespace SweepToneGen
