#pragma once

#include <fstream>
#include <string>
#include <vector>

namespace SweepToneGen {

    class File {
    public:
        using SharedPtr = std::shared_ptr<File>;

    public:
        File();
        virtual ~File();

        File(const File&) = delete;
        File& operator=(const File&) = delete;

        virtual bool init(const std::string& filename);
        virtual bool write(const void* buf, size_t len);
        virtual void close();

        static bool read(const std::string& fileName, std::vector<uint8_t>& data);

    protected:
        bool write(size_t pos, const void* buf, size_t len);

    private:
        std::ofstream file;
        bool isOpened = false;
    };

} // namespace SweepToneGen
