#pragma once

#include "file.h"

#include <fstream> // NOLINT(readability/streams)
#include <string>

namespace SweepToneGen {

    class WavFile: public File {
    public:
        struct SoundInfo {
            int channelCount;
            int sampleRate;
            int sampleSize;
        };

    public:
        WavFile(const SoundInfo& soundInfo);
        ~WavFile();

        WavFile(const WavFile&) = delete;
        WavFile& operator=(const WavFile&) = delete;

        using File::write;

        bool init(const std::string& filename) override;
        bool write(const void* buf, size_t len) override;
        void close() override;

    private:
        bool writeHeader();
        void patchHeader();

    private:
        std::size_t bytesWritten;
        SoundInfo soundInfo;
    };

} // namespace SweepToneGen
