#include <yandex_io/libs/telemetry/latency_data.h>

using namespace YandexIO;

LatencyData::LatencyData()
    : startTime(std::chrono::steady_clock::now())
{
}

std::uint64_t LatencyData::msPassedTillNow() const {
    const auto now = std::chrono::steady_clock::now();
    return static_cast<std::uint64_t>(std::chrono::duration_cast<std::chrono::milliseconds>(now - startTime).count());
}
