#pragma once

#include "mock_params.h"

#include <yandex_io/libs/telemetry/telemetry.h>

#include <gmock/gmock.h>

namespace YandexIO {

    class MockTelemetry: public ITelemetry {
    public:
        MOCK_METHOD(void, reportEvent, (const std::string&, ITelemetry::Flags), (override));
        MOCK_METHOD(void, reportEvent, (const std::string&, const std::string&, ITelemetry::Flags), (override));
        MOCK_METHOD(void, reportError, (const std::string&, ITelemetry::Flags), (override));
        MOCK_METHOD(void, reportError, (const std::string&, const std::string&, ITelemetry::Flags), (override));
        MOCK_METHOD(void, reportLogError, (const std::string&, const std::string&, size_t, const std::string&), (override));
        MOCK_METHOD(void, reportKeyValues, (const std::string&, (const std::unordered_map<std::string, std::string>&), ITelemetry::Flags), (override));

        MOCK_METHOD(std::shared_ptr<const LatencyData>, createLatencyPoint, (), (override));
        MOCK_METHOD(void, reportLatency, (std::shared_ptr<const LatencyData>, const std::string&), (override));
        MOCK_METHOD(void, reportLatency, (std::shared_ptr<const LatencyData>, const std::string&, const std::string&), (override));

        MOCK_METHOD(void, putAppEnvironmentValue, (const std::string&, const std::string&), (override));
        MOCK_METHOD(void, deleteAppEnvironmentValue, (const std::string&), (override));

        MOCK_METHOD(void, setRateLimiter, (const std::string&), (override));

        MOCK_METHOD(void, requestUUID, (UUIDCallback), (override));
        MOCK_METHOD(void, setSenderName, (const std::string&), (override));

        MOCK_METHOD(MockParams*, params, (), (override));
    };

} // namespace YandexIO
