#pragma once

#include <json/json.h>

#include <yandex_io/libs/telemetry/telemetry.h>

namespace YandexIO {
    class NamedLatency {
    public:
        NamedLatency(const std::shared_ptr<ITelemetry>& telemetry);

        void createLatencyPoint(const std::string& latencyPointName);
        void reportLatency(const std::string& latencyPointName, const std::string& eventName, bool removePoint);
        void reportLatency(const std::string& latencyPointName, const std::string& eventName, bool removePoint, const std::string& jsonEvent);
        void reportLatency(const std::string& latencyPointName, const std::string& eventName, bool removePoint, Json::Value jsonEvent);

        template <typename JsonBuilderFunc>
        void reportLatencyBuilder(const std::string& latencyPointName, const std::string& eventName, bool removePoint, JsonBuilderFunc jsonBuilder) {
            std::unique_lock lock(mutex_);
            auto iter = points_.find(latencyPointName);
            if (iter != points_.end()) {
                auto diff = iter->second->msPassedTillNow(); // as soon as possible
                if (removePoint) {
                    points_.erase(iter);
                }
                lock.unlock();
                Json::Value json = jsonBuilder();
                json["value"] = diff;
                reportEvent(eventName, std::move(json));
            } else {
                alertAbsentPoint(latencyPointName);
            }
        }

    private:
        void reportEvent(const std::string& eventName, Json::Value jsonEvent);
        static void alertAbsentPoint(const std::string& latencyPointName);

        std::shared_ptr<ITelemetry> telemetry_;
        std::mutex mutex_;
        std::unordered_map<std::string, std::shared_ptr<const LatencyData>> points_;
    };
} // namespace YandexIO
