#include "null_metrica.h"

#include "null_params.h"

using namespace YandexIO;

NullMetrica::~NullMetrica() = default;

/* Simply drop all calls */
void NullMetrica::reportEvent(const std::string& /* event */, ITelemetry::Flags /* flags */)
{
}

void NullMetrica::reportEvent(const std::string& /* event */, const std::string& /* eventJson */, ITelemetry::Flags /* flags */)
{
}

void NullMetrica::reportError(const std::string& /* errorEventName */, ITelemetry::Flags /* flags */)
{
}

void NullMetrica::reportError(const std::string& /* errorEventName */, const std::string& /* errorValue */, ITelemetry::Flags /* flags */)
{
}

void NullMetrica::reportLogError(const std::string& /* message */, const std::string& /* sourceFileName */, size_t /* sourceLine */, const std::string& /* eventJson */)
{
}

void NullMetrica::reportKeyValues(const std::string& /* eventName */, const std::unordered_map<std::string, std::string>& /* keyValues */, ITelemetry::Flags /* flags */)
{
}

std::shared_ptr<const LatencyData> NullMetrica::createLatencyPoint() {
    return std::make_shared<LatencyData>();
}

void NullMetrica::reportLatency(std::shared_ptr<const LatencyData> /* latencyData */, const std::string& /* eventName */) {
}

void NullMetrica::reportLatency(std::shared_ptr<const LatencyData> /* latencyData */, const std::string& /* eventName */, const std::string& /* eventJson */) {
}

void NullMetrica::putAppEnvironmentValue(const std::string& /* key */, const std::string& /* value */)
{
}

void NullMetrica::deleteAppEnvironmentValue(const std::string& /* key */)
{
}

void NullMetrica::setRateLimiter(const std::string& /* jsonConfig */)
{
}

void NullMetrica::requestUUID(UUIDCallback cb) {
    cb(std::string());
}

void NullMetrica::setSenderName(const std::string& /*name*/) {
}

ITelemetry::IParams* NullMetrica::params() {
    static NullParams params;
    return &params;
}
