#pragma once

#include <yandex_io/libs/telemetry/telemetry.h>

/* Null metrica simply drop all calls and do not try to send anything */
class NullMetrica: public YandexIO::ITelemetry {
public:
    ~NullMetrica();

    void reportEvent(const std::string& event, ITelemetry::Flags flags = 0) override;
    void reportEvent(const std::string& event, const std::string& eventJson, ITelemetry::Flags flags = 0) override;
    void reportError(const std::string& errorEventName, ITelemetry::Flags flags = 0) override;
    void reportError(const std::string& errorEventName, const std::string& errorValue, ITelemetry::Flags flags = 0) override;
    void reportLogError(const std::string& message, const std::string& sourceFileName, size_t sourceLine, const std::string& eventJson) override;
    void reportKeyValues(const std::string& eventName, const std::unordered_map<std::string, std::string>& keyValues, ITelemetry::Flags flags = 0) override;
    std::shared_ptr<const YandexIO::LatencyData> createLatencyPoint() override;
    void reportLatency(std::shared_ptr<const YandexIO::LatencyData> latencyData, const std::string& eventName) override;
    void reportLatency(std::shared_ptr<const YandexIO::LatencyData> latencyData, const std::string& eventName, const std::string& eventJson) override;
    void putAppEnvironmentValue(const std::string& key, const std::string& value) override;
    void deleteAppEnvironmentValue(const std::string& key) override;

    void setRateLimiter(const std::string& jsonConfig) override;

    void requestUUID(UUIDCallback cb) override;
    void setSenderName(const std::string& name) override;

    IParams* params() override;
};
