#include "telemetry_handler.h"

#include <yandex_io/libs/json_utils/json_utils.h>

using namespace quasar;

TelemetryHandler::TelemetryHandler() = default;

void TelemetryHandler::init(std::shared_ptr<YandexIO::ITelemetry> telemetry,
                            std::shared_ptr<ipc::IIpcFactory> ipcFactory)
{
    telemetry_ = std::move(telemetry);
    userConfigProvider_ = std::make_shared<UserConfigProvider>(ipcFactory);

    userConfigProvider_->jsonChangedSignal(IUserConfigProvider::ConfigScope::SYSTEM, "telemetry/rate_limiter").connect([this](const auto& jsonPtr) {
        std::string jsonString;
        if (jsonPtr) {
            jsonString = jsonToString(*jsonPtr);
        }
        telemetry_->setRateLimiter(jsonString);
    }, lifetime_);
}

TelemetryHandler::~TelemetryHandler() {
    lifetime_.die();
}
