#pragma once

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/libs/threading/lifetime.h>

#include <yandex_io/interfaces/user_config/connector/user_config_provider.h>

namespace quasar {

    class TelemetryHandler {
    public:
        TelemetryHandler();
        ~TelemetryHandler();

        void init(std::shared_ptr<YandexIO::ITelemetry> telemetry,
                  std::shared_ptr<ipc::IIpcFactory> ipcFactory);

    private:
        std::shared_ptr<YandexIO::ITelemetry> telemetry_;
        std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        Lifetime lifetime_;
    };

} // namespace quasar
