#include "terminate_waiter.h"

#include <iostream>

using namespace quasar;

namespace {
    void noop(asio::signal_set& set) {
        set.async_wait([&set](const auto& /* error */, int /* signal_number */) { noop(set); });
    }
} // namespace
TerminateWaiter::TerminateWaiter()
    : signals_(ioService_, SIGTERM, SIGINT)
    , ignoredSignals_(ioService_, SIGPIPE) // FIXME: Need to ignore SIGPIPE due to libcurl/libssl behaviour
{
    signals_.async_wait([this](const auto& /* error */, int /* signal_number */) {
        std::cerr << "Received terminating signal. Stopping..." << std::endl;
        ioService_.stop();
    });
    noop(ignoredSignals_);
}

void TerminateWaiter::wait() {
    ioService_.run();
}
