#pragma once

namespace quasar 
{

template<typename F>
auto makeSafeCallback(F callback, Lifetime::Tracker tracker)
{
    return 
        [callback{ std::move(callback) }, tracker{ std::move(tracker) }](auto&&... args) -> void
        {
            if (auto lock = tracker.lock()) {
                callback(std::forward<decltype(args)>(args)...);
            }
        };
}

template<typename F>
auto makeSafeCallback(F callback, Lifetime::Tracker tracker, std::weak_ptr<ICallbackQueue> callbackQueue)
{
    return 
        [callback{ std::move(callback) }, tracker{ std::move(tracker) }, callbackQueue{ std::move(callbackQueue) } ](auto&&... args) -> void
        {
            if (auto cq = callbackQueue.lock()) {
                if (cq->isWorkingThread()) {
                    if (auto lock = tracker.lock()) {
                        callback(std::forward<decltype(args)>(args)...);
                    }
                } else {
                    cq->add(
                        [callback, args = std::make_tuple(std::forward<decltype(args)>(args)...)]() mutable
                        {
                            std::apply(std::move(callback), std::move(args));
                        }, tracker);
                }
            }
        };
}

} // namespace quasar