#include "i_timer_service.h"

namespace quasar
{
template<class Task>
TaskHolder<Task>::TaskHolder(const std::shared_ptr<Task>& task)
    : task_(task)
{
}

template<class Task>
TaskHolder<Task>::TaskHolder(std::shared_ptr<Task>&& task)
    : task_(std::move(task))
{
}

template<class Task>
TaskHolder<Task>::TaskHolder(TaskHolder<Task>&& other) noexcept
    : task_(std::move(other.task_))
{
}

template<class Task>
TaskHolder<Task>::~TaskHolder()
{
    if (task_) {
        task_->stop();
    }
}

template<class Task>
TaskHolder<Task>& TaskHolder<Task>::operator = (TaskHolder<Task>&& other) noexcept
{
    auto tmp = std::move(task_);
    task_ = std::move(other.task_);
    tmp->stop();
    return *this;
}

template<class Task>
TaskHolder<Task>& TaskHolder<Task>::operator = (const std::shared_ptr<Task>& task)
{
    auto tmp = std::move(task_);
    task_ = task;
    tmp->stop();
    return *this;
}

template<class Task>
TaskHolder<Task>& TaskHolder<Task>::operator = (std::shared_ptr<Task>&& task)
{
    auto tmp = std::move(task_);
    task_ = std::move(task);
    tmp->stop();
    return *this;
}

template<class Task>
const Task* TaskHolder<Task>::operator ->() const
{
    return task_.get();
}

template<class Task>
Task* TaskHolder<Task>::operator ->()
{
    return task_.get();
}

template<class Task>
bool TaskHolder<Task>::operator !() const
{
    return task_ ? task_->expired() : true;
}

template<class Task>
TaskHolder<Task>::operator bool() const
{
    return task_ ? !task_->expired() : false;
}

} // namespace quasar
