#pragma once

#include <atomic>
#include <condition_variable>
#include <memory>
#include <mutex>

namespace quasar {

    class Lifetime {
    public:
        class Tracker {
        public:
            Tracker() = default;
            Tracker(std::nullptr_t);
            Tracker(const Lifetime& lifetime);

            template <class Y>
            Tracker(const std::shared_ptr<Y>& owner)
                : soul_(owner)
            {
            }

            template <class Y>
            Tracker(const std::weak_ptr<Y>& owner)
                : soul_(owner)
            {
            }

            template <class Y>
            Tracker(std::weak_ptr<Y>&& owner)
                : soul_(std::move(owner))
            {
            }

            bool isValid() const noexcept;
            bool expired() const noexcept;
            std::shared_ptr<const void> lock() const noexcept;

        private:
            friend class Lifetime;
            struct LifetimeTag {};
            Tracker(std::weak_ptr<const void> soul, LifetimeTag /*tag*/);

        private:
            std::weak_ptr<const void> soul_;
            bool lifetime_{false};
        };

        ~Lifetime();
        Lifetime() = default;
        Lifetime(const Lifetime&) = delete;
        Lifetime& operator=(const Lifetime&) = delete;

        Tracker tracker() const noexcept;
        void die() noexcept;
        bool expired() const noexcept;
        long use_count() const noexcept;

        static const Lifetime immortal;

    private:
        void resetTracker() noexcept;

    private:
        mutable std::mutex mutex_;
        mutable std::condition_variable cv_;
        mutable std::shared_ptr<void> soul_;
    };

} // namespace quasar
