#include "steady_condition_variable.h"

#include <time.h>

using namespace quasar;

SteadyConditionVariable::SteadyConditionVariable()
{
    if (pthread_condattr_init(&condAttr_) != 0) {
        throw ErrnoException(errno, "Cannot pthread_condattr_init");
    }
    if (pthread_condattr_setclock(&condAttr_, CLOCK_MONOTONIC) != 0)
    {
        pthread_condattr_destroy(&condAttr_);
        throw ErrnoException(errno, "Cannot pthread_condattr_setclock");
    }
    if (pthread_cond_init(&cond_, &condAttr_) != 0)
    {
        const int errnoSaved = errno;
        pthread_condattr_destroy(&condAttr_);

        throw ErrnoException(errnoSaved, "Cannot pthread_cond_init");
    }
}

void SteadyConditionVariable::notify_one()
{
    pthread_cond_signal(&cond_);
}

void SteadyConditionVariable::notify_all()
{
    pthread_cond_broadcast(&cond_);
}

SteadyConditionVariable::~SteadyConditionVariable()
{
    pthread_cond_destroy(&cond_);
    pthread_condattr_destroy(&condAttr_);
}
