#pragma once
#include "i_timer_service.h"
#include "steady_condition_variable.h"

namespace quasar {

    class TimerServiceTask;
    class TimerService: public ITimerService {
    public:
        using ExceptionHandler = std::function<void(std::exception_ptr exptr)>;

        TimerService(ExceptionHandler eh = nullptr);
        TimerService(const TimerService&) = delete;
        ~TimerService() = default;

        TimerService& operator=(const TimerService&) = delete;

        void shutdown();

    public: // ITimerService methods
        std::shared_ptr<IPeriodicTask> createPeriodicTask(std::chrono::milliseconds interval, std::function<void()> callback, const Lifetime::Tracker& tracker, std::weak_ptr<ICallbackQueue> callbackQueue) noexcept override;
        std::shared_ptr<IDelayedTask> createDelayedTask(std::chrono::milliseconds interval, std::function<void()> callback, const Lifetime::Tracker& tracker, std::weak_ptr<ICallbackQueue> callbackQueue) noexcept override;

    private:
        std::shared_ptr<TimerServiceTask> createTask(bool singleShot, std::chrono::milliseconds interval, std::function<void()> callback, Lifetime::Tracker tracker, std::weak_ptr<ICallbackQueue> callbackQueue) noexcept;

    private:
        friend class TimerServiceTask;
        struct Core;
        std::shared_ptr<Core> core_;
    };

} // namespace quasar
