#include "wakeup_fd.h"

#include <yandex_io/libs/errno/errno_exception.h>

#include <unistd.h>

using namespace quasar;

WakeupFd::WakeupFd(int flags) {
    fd_ = ::eventfd(0, flags);
    if (fd_ == -1) {
        throw ErrnoException(errno, "eventfd");
    }
}

WakeupFd::WakeupFd(WakeupFd&& other) noexcept
    : fd_(other.fd_)
{
    other.fd_ = -1;
}

WakeupFd& WakeupFd::operator=(WakeupFd&& other) noexcept {
    fd_ = other.fd_;
    other.fd_ = -1;

    return *this;
}

WakeupFd::~WakeupFd() {
    if (fd_ != -1) {
        ::close(fd_);
    }
}

int WakeupFd::fd() const {
    return fd_;
}

void WakeupFd::signal() const {
    eventfd_t val = 1;
    int res = eventfd_write(fd_, val);
    if (res == -1) {
        throw ErrnoException(errno, "eventfd write()");
    }
}

eventfd_t WakeupFd::read() const {
    eventfd_t val = 0;
    int res = eventfd_read(fd_, &val);
    if (res == -1) {
        throw ErrnoException(errno, "eventfd read()");
    }

    return val;
}

bool WakeupFd::tryRead(eventfd_t& val) const {
    int res = ::read(fd_, &val, 8);
    if (res == -1 && errno == EWOULDBLOCK) {
        return false;
    }
    if (res == -1) {
        throw ErrnoException(errno, "eventfd read()");
    }
    if (res != sizeof(eventfd_t)) {
        throw std::runtime_error("eventfd read() returned wrong num bytes");
    }

    return true;
}

bool WakeupFd::tryRead() const {
    eventfd_t val = 0;

    return tryRead(val);
}
