#pragma once

#include <sys/eventfd.h>

namespace quasar {

    struct WakeupFd {
        WakeupFd(int flags = 0);
        ~WakeupFd();

        WakeupFd(WakeupFd&& other) noexcept;
        WakeupFd& operator=(WakeupFd&& other) noexcept;
        WakeupFd(const WakeupFd& other) = delete;
        WakeupFd& operator=(const WakeupFd& other) = delete;

        int fd() const;
        void signal() const;
        eventfd_t read() const;

        // tryRead only works if it was constructed with EFD_NONBLOCK
        bool tryRead(eventfd_t& val) const;
        bool tryRead() const;

        int fd_;
    };

} // namespace quasar
