#pragma once

#include <chrono>

namespace quasar {
    struct TriggerConfig {
        unsigned limit;
        std::chrono::seconds interval; // zero interval means turned off trigger
    };

    struct TimeCounter {
        using TimePoint = std::chrono::steady_clock::time_point;
        unsigned count;
        TimePoint updated;
        TimeCounter();

    protected:
        bool updateImpl(unsigned newValue, TimePoint now, const TriggerConfig& /*cfg*/, bool lowOrHigh);
    };

    // to trigger when difference between counters are dropped below limit over interval
    class TooLowTrigger: public TimeCounter {
    public:
        bool update(unsigned newValue, TimePoint /*now*/, const TriggerConfig& /*cfg*/);
    };

    // to trigger when difference between counters are increased above limit over interval
    class TooHighTrigger: public TimeCounter {
    public:
        bool update(unsigned newValue, TimePoint /*now*/, const TriggerConfig& /*cfg*/);
    };

    // triggered when it false for period
    class FalseTooLong {
        bool value{false};
        using TimePoint = TimeCounter::TimePoint;
        TimePoint updated;

    public:
        FalseTooLong();
        void update(bool newValue, TimePoint /*now*/);
        bool check(TimePoint now, std::chrono::seconds maxInterval) const;
    };

    class OnceADayTrigger {
        std::chrono::minutes triggerTime; // since 00:00 of the day
        std::chrono::system_clock::time_point lastTriggered;

    public:
        OnceADayTrigger();
        void changeTime(std::chrono::minutes newValue);
        bool check(std::chrono::system_clock::time_point now); // return true if should be triggered, next true can be returned only after 24 hours
    };
} // namespace quasar
