#include "vins_utils.h"

#include <yandex_io/libs/json_utils/json_utils.h>

std::string createVinsResponsePayload(const std::list<Json::Value>& directives) {
    Json::Value root;
    root["header"]["request_id"] = "unused_request_id";
    root["voice_response"]["output_speech"] = "";

    Json::Value directiveArray = Json::arrayValue;
    for (const auto& directive : directives) {
        directiveArray.append(directive);
    }

    root["response"]["directives"] = std::move(directiveArray);

    return quasar::jsonToString(root);
}
