#pragma once

#include <array>
#include <vector>
#include <string>

namespace quasar {

    struct RMSChannel {
        std::string name;
        using DataType = std::array<float, 40>;
        float average = 0.0;
        float rawAverage = 0.0;
        DataType data;
        RMSChannel(std::string /*n*/, float /*average*/, float /*rawAverage*/, DataType /*d*/);
        RMSChannel() = default;
    };

    using RMSInfo = std::vector<RMSChannel>;

} // namespace quasar
