#pragma once

#include "rms_info.h"

#include <yandex_io/sdk/audio_source/defines.h>

#include <json/json.h>

#include <memory>

namespace quasar {

    class VoiceStats {
    public:
        virtual ~VoiceStats() = default;

        virtual void setRMSCorrection(float) = 0;
        virtual RMSInfo getRms() = 0;
        virtual RMSInfo getWeightedRms(const std::vector<float>& fftWindow) = 0;
        virtual void pushAudioChannels(const YandexIO::ChannelsData&) = 0;
        virtual void calcOnVqe(bool) = 0;

    public:
        static std::shared_ptr<VoiceStats> create();
        static Json::Value rmsToJson(const RMSInfo& /*rms*/);
        static Json::Value rmsToJsonPacked(const RMSInfo& /*rms*/);
    };

} // namespace quasar
