#pragma once

#include "websocket_events_logger.h"

#include <websocketpp/config/asio_client.hpp>

namespace quasar {

    /**
     * Client config with asio transport and TLS enabled.
     *
     * But also it writes websocketpp logs into Quasar logger.
     */
    struct LoggableAsioTlsClient: public websocketpp::config::asio_tls_client {
        using type = LoggableAsioTlsClient;
        using base = websocketpp::config::asio_tls_client;

        using concurrency_type = base::concurrency_type;

        using request_type = base::request_type;
        using response_type = base::response_type;

        using message_type = base::message_type;
        using con_msg_manager_type = base::con_msg_manager_type;
        using endpoint_msg_manager_type = base::endpoint_msg_manager_type;

        using alog_type = WebsocketEventsLogger<concurrency_type, websocketpp::log::alevel>;
        using elog_type = WebsocketEventsLogger<concurrency_type, websocketpp::log::elevel>;

        using rng_type = base::rng_type;

        struct transport_config: public base::transport_config {
            using concurrency_type = type::concurrency_type;
            using alog_type = type::alog_type;
            using elog_type = type::elog_type;
            using request_type = type::request_type;
            using response_type = type::response_type;
            using socket_type = base::transport_config::socket_type;
        };

        using transport_type = base::transport_type;
    };

} // namespace quasar
