#pragma once

#include <yandex_io/libs/logging/logging.h>

#include <websocketpp/config/asio.hpp>

namespace websocketpp::config {

    template <typename concurrency, typename names>
    class QuasarWsLogger: public log::basic<concurrency, names> {
    public:
        const char* E_TAG = "WSServer::error";
        const char* A_TAG = "WSServer::access";

        QuasarWsLogger(const log::level level, const log::channel_type_hint::value hint)
            : log::basic<concurrency, names>(level, hint)
            , hint_(hint)
                  {};

        void write(log::level channel, std::string const& msg) {
            YIO_DEFINE_LOG_MODULE_IN_SCOPE("websocket");

            if (!this->dynamic_test(channel)) {
                return;
            }

            if (hint_ == log::channel_type_hint::access) {
                switch (channel) {
                    case log::alevel::connect:
                    case log::alevel::disconnect:
                        YIO_LOG_INFO("{" << A_TAG << "::" << names::channel_name(channel) << "} " << msg);
                        break;
                    default:
                        // this thing logs A LOT, so we keep it in debug
                        // TODO: add logic if a more granular control is needed
                        YIO_LOG_TRACE("{" << A_TAG << "::" << names::channel_name(channel) << "} " << msg);
                }
            } else {
                switch (channel) {
                    case log::elevel::devel:
                    case log::elevel::library:
                        YIO_LOG_DEBUG("{" << E_TAG << "::" << names::channel_name(channel) << "} " << msg);
                        break;
                    case log::elevel::info:
                        YIO_LOG_INFO("{" << E_TAG << "::" << names::channel_name(channel) << "} " << msg);
                        break;
                    case log::elevel::warn:
                        YIO_LOG_WARN("{" << E_TAG << "::" << names::channel_name(channel) << "} " << msg);
                        break;
                    case log::elevel::rerror:
                        if (errorAsWarn_) {
                            YIO_LOG_WARN("{" << E_TAG << "::" << names::channel_name(channel) << "} " << msg);
                            break;
                        };
                    case log::elevel::fatal:
                    default:
                        YIO_LOG_ERROR_EVENT("WebsocketppLogger.Error", "{" << E_TAG << "::" << names::channel_name(channel) << "} " << msg);
                }
            }
        };

        void setErrorAsWarn(bool value) {
            errorAsWarn_ = value;
        }

    private:
        log::channel_type_hint::value hint_;
        bool errorAsWarn_{false};
    };

} // namespace websocketpp::config
