#include "metrica2_service.h"

#include <yandex_io/libs/metrica/clickdaemon/clickdaemon_consumer.h>
#include <yandex_io/libs/telemetry/telemetry.h>

using namespace quasar;

Metrica2Service::Metrica2Service(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
{
}

std::string Metrica2Service::getServiceName() const {
    return MetricaEndpoint::SERVICE_NAME;
}

void Metrica2Service::start() {
    endpointPtr_ = std::make_unique<MetricaEndpoint>(device_, ipcFactory_);
    endpointPtr_->registerConsumer<ClickdaemonConsumer>();
    endpointPtr_->start();
}
