#pragma once

#include <yandex_io/libs/configuration/configuration_helper.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/metrica/base/metrica_consumer.h>
#include <yandex_io/libs/metrica/base/client_stats.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <chrono>

namespace quasar {

    class MetricaEndpoint {
    public:
        static const std::string SERVICE_NAME;

        MetricaEndpoint(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        virtual ~MetricaEndpoint();

        MetricaEndpoint(const MetricaEndpoint&) = delete;
        MetricaEndpoint(MetricaEndpoint&&) = delete;
        MetricaEndpoint& operator=(const MetricaEndpoint&) = delete;
        MetricaEndpoint& operator=(MetricaEndpoint&&) = delete;

        int port() const;
        void start();

        template <typename TConsumer>
        void registerConsumer();

    private:
        void processQuasarMessage(const ipc::SharedMessage& message, ipc::IServer::IClientConnection& connection);

        void processMetricaConfig(const Json::Value& config);

        std::shared_ptr<YandexIO::IDevice> device_;

    protected:
        std::shared_ptr<ipc::IServer> server_;
        std::vector<std::unique_ptr<IMetricaConsumer>> consumers_;

    private:
        ConfigurationHelper configHelper_;
        std::map<std::string, std::chrono::time_point<std::chrono::steady_clock>> latencyPointsStart_;

        ClientStats clientStats_;
    };

    template <typename TConsumer>
    void MetricaEndpoint::registerConsumer() {
        auto consumersConfig = configHelper_.getCurrentConfig()["consumers"];

        consumers_.push_back(
            std::make_unique<TConsumer>(consumersConfig[TConsumer::CONSUMER_NAME], device_));
    }

} // namespace quasar
