#pragma once

#include <yandex_io/libs/appmetrica/app_metrica.h>
#include <yandex_io/libs/appmetrica/app_metrica_client.h>
#include <yandex_io/libs/appmetrica/app_metrica_sender.h>
#include <yandex_io/libs/configuration/configuration_helper.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/metrica/base/events_database.h>
#include <yandex_io/libs/metrica/base/client_stats.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/libs/threading/periodic_executor.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <chrono>
#include <mutex>
#include <optional>

namespace quasar {

    class AppMetricaEndpoint {
    public:
        static const std::string SERVICE_NAME;

        AppMetricaEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            const std::shared_ptr<ipc::IIpcFactory>& ipcFactory);
        AppMetricaEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            const std::shared_ptr<ipc::IIpcFactory>& ipcFactory,
            std::shared_ptr<ReportConfiguration> reportConfig,
            std::chrono::milliseconds reportSendPeriod = std::chrono::seconds(10));
        ~AppMetricaEndpoint();

        int port() const;

        void setPassportUid(const std::string& uid);

        AppMetricaEndpoint(const AppMetricaEndpoint&) = delete;
        AppMetricaEndpoint(AppMetricaEndpoint&&) = delete;
        AppMetricaEndpoint& operator=(const AppMetricaEndpoint&) = delete;
        AppMetricaEndpoint& operator=(AppMetricaEndpoint&&) = delete;

        static MetricaMetadata loadMetadata(const std::string& filepath);
        static void saveMetadata(const std::string& filepath, const MetricaMetadata& metadata);

    private:
        void initIpc(const std::shared_ptr<ipc::IIpcFactory>& ipcFactory);

        void setUuid(const std::string& uuid);
        void processAppmetricaConfig(const Json::Value& appmetricaConfig);

        std::shared_ptr<EventsDatabase> createEventsDatabase(const Json::Value& config);

    private:
        std::shared_ptr<YandexIO::IDevice> device_;

        std::shared_ptr<ReportConfiguration> reportConfig_;
        std::shared_ptr<ipc::IServer> server_;
        std::thread initConfigThread_;

        std::optional<std::string> passportUid_;
        std::shared_ptr<EventsDatabase> eventsDatabse_;
        std::unique_ptr<AppMetrica> appMetrica_;

        std::mutex importantEventsMutex_;
        std::shared_ptr<const std::unordered_set<std::string>> importantEvents_;

        // This cache is used to keep location and timezone saved if metricaSender_ is not set up at the moment metrica
        // got location and timezone from geolocation module
        quasar::proto::Timezone timezoneCache_;
        quasar::proto::Location locationCache_;
        std::unordered_set<std::string> envKeysBlacklistCache_;

        std::map<std::string, std::chrono::time_point<std::chrono::steady_clock>> latencyPointsStart_;

        std::mutex configMutex_;
        std::string configCache_;

        std::shared_ptr<ipc::IConnector> metrica2Connector_;
        ipc::IConnector::OnDone onMetrica2Done_;
        ipc::IConnector::OnError onMetrica2Error_;

        void startInitConfigThread();
        void initConfigAndStart();

        void processQuasarMessage(const ipc::SharedMessage& message, ipc::IServer::IClientConnection& connection);

        void onClientConnected(ipc::IServer::IClientConnection& connection);

        void changeRateLimiter(const std::optional<Json::Value>& configOpt);

        /* Need to restart session at least one time a day, so Location charts will work */
        std::mutex startSessionMutex_;
        std::chrono::steady_clock::time_point lastStartedSessionTimePoint_ = std::chrono::steady_clock::now();

        std::string metricaUuid_;
        std::mutex startupIdentifiersMutex_;

        std::unique_ptr<ConfigurationHelper> configHelper_;
        ClientStats clientStats_;

    public:
        // for testing only
        std::function<void(const quasar::proto::MetricaMessage&)> afterHandleMetricaMessage;
    };

} // namespace quasar
