#include "metrica_service.h"

#include <yandex_io/libs/appmetrica/startup_configuration.h>
#include <yandex_io/libs/device/defines.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/telemetry/telemetry.h>

using namespace quasar;

MetricaService::MetricaService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
{
}

MetricaService::~MetricaService()
{
    lifetime_.die();
}

std::string MetricaService::getServiceName() const {
    return AppMetricaEndpoint::SERVICE_NAME;
}

void MetricaService::start() {
    endpointPtr_ = std::make_unique<AppMetricaEndpoint>(device_, ipcFactory_);
    authProvider_->ownerAuthInfo().connect(
        [this](const auto& authInfo) {
            endpointPtr_->setPassportUid(authInfo->passportUid);
        }, lifetime_);
}
