#pragma once

#include "app_metrica_endpoint.h"

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <memory>

namespace quasar {
    class MetricaService: public QuasarService {
    public:
        explicit MetricaService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<quasar::IAuthProvider> authProvider);
        ~MetricaService();
        std::string getServiceName() const override;

    private:
        void start() override;

    private:
        Lifetime lifetime_;
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IAuthProvider> authProvider_;
        std::unique_ptr<AppMetricaEndpoint> endpointPtr_;
    };
} // namespace quasar
