#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/metrics_collector/i_metrics_collector.h>
#include <yandex_io/libs/threading/periodic_executor.h>
#include <yandex_io/libs/net/wifi_info.h>
#include <yandex_io/protos/quasar_proto_forward.h>

#include <memory>

namespace quasar {

    class MonitorEndpoint {
    public:
        MonitorEndpoint(std::shared_ptr<YandexIO::IDevice> device,
                        std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                        std::unique_ptr<IMetricsCollector> collector);

        ~MonitorEndpoint();

        static const std::string SERVICE_NAME;

        int getPort() const {
            return server_->port();
        }

    private:
        static constexpr int DEFAULT_DISK_MONITOR_PERIOD_SECONDS = 24 * 60 * 60;

        void handleQuasarMessage(const ipc::SharedMessage& message, ipc::IServer::IClientConnection* connection);

        void doBugReport(const std::string& bugReportId);

        void dumpMetrics();
        void collectDiskUsageStats();
        void wifiStats();
        net::WifiInfoSettings getWifiStatsSettings();
        bool applyWifiStatsSettings(const Json::Value& cfg);
        static int64_t collectDirectoryDiskUsageInfo(const std::string& path, int maxDepth);
        void updateConfig(const std::string& config);
        void parseDiskUsageConfig(const Json::Value& config);
        void resetDiskUsageCollector();
        void resetWifiStatsCollector();

        void collectPstore(const std::string& pstorePath);

        MonitorEndpoint(const MonitorEndpoint&) = delete;
        MonitorEndpoint& operator=(const MonitorEndpoint&) = delete;

        std::shared_ptr<YandexIO::IDevice> device_;

        std::unique_ptr<IMetricsCollector> metricsCollector_;

        std::shared_ptr<ipc::IServer> server_;

        std::unique_ptr<PeriodicExecutor> dumpMetricsExecutor_;
        std::unique_ptr<PeriodicExecutor> diskUsageExecutor_;
        std::unique_ptr<PeriodicExecutor> wifiStatsExecutor_;
        std::chrono::seconds diskUsageMonitorPeriod_{DEFAULT_DISK_MONITOR_PERIOD_SECONDS};
        std::atomic<bool> collectDiskUsageInfo_{false};
        std::chrono::seconds wifiStatsPeriod_{0};
        std::atomic_bool sendWifiStats_{false};
        std::mutex wifiStatsSettingsMutex_;
        net::WifiInfoSettings wifiStatsSettings_;

        struct DiskUsagePath {
            std::string root;
            int maxDepth;
        };
        std::vector<DiskUsagePath> pathsToMonitor_;

        std::unique_ptr<PeriodicExecutor> pstoreCollectorExecutor_;
    };

} // namespace quasar
