#include "monitor_service.h"

#include <yandex_io/libs/telemetry/telemetry.h>

using namespace quasar;

MonitorService::MonitorService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::unique_ptr<IMetricsCollector> collector)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , collector_(std::move(collector))
{
}

std::string MonitorService::getServiceName() const {
    return MonitorEndpoint::SERVICE_NAME;
}

void MonitorService::start() {
    endpointPtr_ = std::make_unique<MonitorEndpoint>(device_, ipcFactory_, std::move(collector_));
}
