#pragma once

#include "monitor_endpoint.h"

#include <yandex_io/metrica/monitor/metrics_collector/metrics_collector.h>

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <memory>

namespace quasar {
    class MonitorService: public QuasarService {
    public:
        MonitorService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::unique_ptr<IMetricsCollector> collector);
        std::string getServiceName() const override;

    private:
        void start() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::unique_ptr<IMetricsCollector> collector_;
        std::unique_ptr<MonitorEndpoint> endpointPtr_;
    };
} // namespace quasar
