#pragma once

#include "batcher.h"

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/metrica/db/i_events_db.h>
#include <yandex_io/libs/appmetrica/report_configuration.h>
#include <yandex_io/libs/appmetrica/proto/metrica.pb.h>
#include <yandex_io/libs/appmetrica/app_metrica_sender_base.h>

#include <functional>

namespace quasar {
    struct AppmetricaBatch {
        ReportMessage batch_;
        bool completed_{false};
        std::optional<YandexIO::ITelemetryEventsDB::Environment> currentEnv_;
        std::optional<YandexIO::ITelemetryEventsDB::Event> unsentEvent_;
        ReportMessage::Session::SessionDesc sessionDesc_;
        std::uint32_t size_{0};

        AppmetricaBatch();

        bool append(YandexIO::ITelemetryEventsDB::Event event, YandexIO::ITelemetryEventsDB::Environment env);
        void reset();
        bool hasUnsent() const;
        std::uint32_t size() const;

        void applyEnv();
        bool tryAdd(YandexIO::ITelemetryEventsDB::Event event);
        void complete();
    };

    class AppmetricaBatcher: public Batcher<AppmetricaBatch> {
    public:
        AppmetricaBatcher(std::shared_ptr<YandexIO::IDevice> device);

        void setOnReady(std::function<void()> callback); // call once when batcher is ready to send

        // some extra envs
        void setTimezoneOffsetSec(int32_t offsetSec);
        void setLocation(double lat, double lon);

    private:
        // batching methods
        std::chrono::seconds getMaxBatchCollectingTime() override;
        bool sendBatch() override;

        void ready();
        void bootstrap(StartupConfiguration startupConfig);

        std::shared_ptr<YandexIO::IDevice> device_;
        bool ready_{false};
        std::function<void()> readyCallback_;
        std::unique_ptr<ReportConfiguration> reportConfig_;

        class IntervalsRing {
            std::vector<std::chrono::seconds> ring;
            unsigned curPos;

        public:
            IntervalsRing(std::vector<std::chrono::seconds> intervals);
            void next();
            void reset();
            std::chrono::seconds get() const;
        };

        IntervalsRing intervals_;

        std::function<void()> readyForNext_;
        AppMetricaSenderBase sender_;
    };
} // namespace quasar
