#include "clickdaemon_batcher.h"

#include <yandex_io/libs/threading/callback_queue.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/metrica/db/utils.h>
#include <yandex_io/libs/base/named_callback_queue.h>

YIO_DEFINE_LOG_MODULE("clickdaemonBatcher");

using namespace quasar;
using namespace YandexIO;

bool ClickdaemonBatch::hasUnsent() {
    return false;
}

void ClickdaemonBatch::reset() {
    batch_.clear();
    size_ = 0;
}

std::uint32_t ClickdaemonBatch::size() const {
    return size_;
}

bool ClickdaemonBatch::append(ITelemetryEventsDB::Event event, ITelemetryEventsDB::Environment env) {
    if (batch_.empty() || !equalEnvs(batch_.back().env, env)) {
        batch_.emplace_back(ClickdaemonSenderBase::EventsWithCommonEnv{.events = {std::move(event)}, .env = std::move(env)});
    } else {
        batch_.back().events.emplace_back(std::move(event));
    }
    return ++size_ < maxEventsInBatch_;
}

// batcher

ClickdaemonBatcher::ClickdaemonBatcher(std::shared_ptr<YandexIO::IDevice> device, const Config& config, const std::string& uuid)
    : Batcher("clickdaemonBatcher")
    , device_(std::move(device))
    , config_(config)
    , deviceInfo_{
          .deviceId = device_->deviceId(),
          .platform = device_->configuration()->getDeviceType(),
          .softwareVersion = device_->softwareVersion(),
          .uuid = uuid,
      }
    , sender_(device_, [this](int retryNum) {
        return delayTimingsPolicy_.calcHttpClientRetriesDelay(retryNum);
    }, true)
{
    YIO_LOG_INFO("clck uri " << config_.endpointUri);
    batch_.maxEventsInBatch_ = config_.maxEventsInBatch;
}

std::chrono::seconds ClickdaemonBatcher::getMaxBatchCollectingTime() {
    return config_.maxBatchCollectingTime;
}

bool ClickdaemonBatcher::sendBatch() {
    try {
        return sender_.sendEvents(config_.endpointUri, batch_.batch_, deviceInfo_);
    } catch (...) {
    }
    return false;
}
