#pragma once

#include "batcher.h"

#include <yandex_io/libs/metrica/db/i_events_db.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/metrica/clickdaemon/clickdaemon_sender_base.h>
#include <yandex_io/libs/delay_timings_policy/delay_timings_policy.h>

#include <vector>
#include <chrono>

namespace quasar {
    struct ClickdaemonBatch {
        std::vector<ClickdaemonSenderBase::EventsWithCommonEnv> batch_;
        std::uint32_t size_{0};
        std::uint32_t maxEventsInBatch_{50};

        bool append(YandexIO::ITelemetryEventsDB::Event event, YandexIO::ITelemetryEventsDB::Environment env);
        void reset();
        static bool hasUnsent();
        std::uint32_t size() const;
    };

    class ClickdaemonBatcher: public Batcher<ClickdaemonBatch> {
    public:
        struct Config {
            std::uint32_t maxEventsInBatch{50};
            std::chrono::seconds maxBatchCollectingTime{20};
            std::string endpointUri;
        };

        ClickdaemonBatcher(std::shared_ptr<YandexIO::IDevice> device, const Config& config, const std::string& uuid);

    private:
        bool sendBatch() override; // return true on success
        std::chrono::seconds getMaxBatchCollectingTime() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::function<void()> readyForNext_;
        Config config_;
        const ClickdaemonSenderBase::DeviceInfo deviceInfo_;
        BackoffRetriesWithRandomPolicy delayTimingsPolicy_;
        ClickdaemonSenderBase sender_;
    };
} // namespace quasar
