#pragma once

#include "teleme3d_endpoint.h"
#include "clickdaemon_batcher.h"
#include "appmetrica_batcher.h"

namespace quasar {
    class DefaultSinksConfigurer: public Teleme3dEndpoint::SinksConfigurer {
    public:
        DefaultSinksConfigurer(std::shared_ptr<YandexIO::IDevice> device);

        void registerSinks(const std::shared_ptr<YandexIO::IDevice>& device, const std::shared_ptr<YandexIO::ITelemetryEventsDB>& eventsDb) override;
        void updateConfig(const Json::Value& config) override;
        void setTimezoneOffsetSec(int32_t offsetSec) override;
        void setLocation(double lat, double lon) override;

    private:
        AppmetricaBatcher appmetricaBatcher_;
        ClickdaemonBatcher clickdaemonBatcher_;
    };
} // namespace quasar
