#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/metrica/db/i_events_db.h>
#include <yandex_io/libs/metrica/base/metrica_session_provider.h>

namespace quasar {

    class Teleme3dEndpoint {
    public:
        static const std::string SERVICE_NAME;

        class SinksConfigurer {
        public:
            virtual void registerSinks(const std::shared_ptr<YandexIO::IDevice>& device, const std::shared_ptr<YandexIO::ITelemetryEventsDB>& eventsDb) = 0;
            virtual void updateConfig(const Json::Value& config) = 0;
            virtual void setTimezoneOffsetSec(int32_t offsetSec) = 0;
            virtual void setLocation(double lat, double lon) = 0;
            virtual ~SinksConfigurer() = default;
        };

        Teleme3dEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            const std::shared_ptr<ipc::IIpcFactory>& ipcFactory,
            std::unique_ptr<SinksConfigurer> sinksConfigurer);

        void setPassportUid(const std::string& uid);

    private:
        void registerSinks();
        void processQuasarMessage(const ipc::SharedMessage& message, ipc::IServer::IClientConnection& connection);
        YandexIO::ITelemetryEventsDB::Event buildEvent(const TString& name);

        std::atomic<quasar::proto::ConnectionType> connectionType_{quasar::proto::CONNECTION_TYPE_UNKNOWN};
        std::mutex dataMutex_;
        std::string userId_;
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<quasar::ICallbackQueue> dbQueue_;
        std::shared_ptr<YandexIO::ITelemetryEventsDB> eventsDb_;
        MetricaSessionProvider sessionProvider_;

        std::unique_ptr<SinksConfigurer> sinksConfigurer_;

        std::shared_ptr<ipc::IServer> server_;
    };

} // namespace quasar
