#include "teleme3d_service.h"
#include "default_sinks_configurer.h"

#include <yandex_io/libs/appmetrica/startup_configuration.h>
#include <yandex_io/libs/device/defines.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/telemetry/telemetry.h>

using namespace quasar;

Teleme3dService::Teleme3dService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
{
}

Teleme3dService::~Teleme3dService()
{
    lifetime_.die();
}

std::string Teleme3dService::getServiceName() const {
    return Teleme3dEndpoint::SERVICE_NAME;
}

void Teleme3dService::start() {
    endpointPtr_ = std::make_unique<Teleme3dEndpoint>(device_, ipcFactory_, std::make_unique<DefaultSinksConfigurer>(device_));
    authProvider_->ownerAuthInfo().connect(
        [this](const auto& authInfo) {
            endpointPtr_->setPassportUid(authInfo->passportUid);
        }, lifetime_);
}
