#!/bin/sh

#
# When Cycle OTA is applied: /system/vendor/quasar/cycle_ota file should
# exist (or name should be replaced). When this file is found after OTA
# on a boot up -> this file should be deleted. So after reboot it will be
# possible to understand that device was successfully updated again
# (in that case cycle_ota file should exist), or some error happened
# (because cycle_ota file does not exist only when ota was applied and file
#  was removed by this script)
#

# NOTE: cycle_ota file should be added to platforms/{$PLATFORM}/data during build!
#       Script should be called in onboot.sh script. Script also should be added to
#       platforms/{$PLATFORM}/data

if [ -f "/system/vendor/quasar/cycle_ota" ]; then
    # Ota was applied successfully. Increase successfull_ota value
    GOOD_OTA_COUNT_FILE="/data/successfull_ota"
    if [ -f $GOOD_OTA_COUNT_FILE ]; then
        OLD_VALUE=$(cat "$GOOD_OTA_COUNT_FILE")
        NEW_VALUE=$((OLD_VALUE+1))
        echo "$NEW_VALUE" > "$GOOD_OTA_COUNT_FILE"
    else
        echo "1" > "$GOOD_OTA_COUNT_FILE"
    fi
    # remove cycle_ota file, so after reboot if this won't exist,
    # we will know that OTA failed
    rm "/system/vendor/quasar/cycle_ota"
else
    # Ota apply failed (device was rebooted but cycle_ota didn't appear). This
    # may happen if device was rebooted by user or OTA really failed
    # Increase bad_ota value
    BAD_OTA_COUNT_FILE="/data/bad_ota"
    if [ -f $BAD_OTA_COUNT_FILE ]; then
        OLD_VALUE=$(cat "$BAD_OTA_COUNT_FILE")
        NEW_VALUE=$((OLD_VALUE+1))
        echo "$NEW_VALUE" > "$BAD_OTA_COUNT_FILE"
    else
        echo "1" > "$BAD_OTA_COUNT_FILE"
    fi
fi

