#!/bin/bash
# Script stops if ssid is empty in 10 seconds after reboot

while true; do
    adb shell reboot
    sleep 10
    while true; do
        SSID=`adb shell LD_LIBRARY_PATH=/system/vendor/quasar/libs/ curl localhost:8080/ssid 2>/dev/null | grep 'ssid'`
        if [ ! -z "$SSID" ]; then
            break;
        fi
    done
    echo "SSID: " "$SSID"
    LEVEL=`echo "$SSID" | grep "level"`
    if [ -z "$LEVEL" ]; then
        echo "SSID is empty. Waiting for 10 seconds."
        sleep 10;
        SSID=`adb shell LD_LIBRARY_PATH=/system/vendor/quasar/libs/ curl localhost:8080/ssid | grep 'ssid'`
        echo "SSID: " "$SSID"
        LEVEL=`echo "$SSID" | grep "level"`
        echo "LEVEL: " "$LEVEL"
        if [ -z "$LEVEL" ]; then
            break;
        fi
    fi
done

echo $SSID
